/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.QuiverTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5682;
import net.minecraft.class_5684;
import net.minecraft.class_918;

public class QuiverTooltipComponent
implements class_5684 {
    public static final class_2960 TEXTURE_LOCATION = class_5682.field_28359;
    private final List<class_1799> items;
    private final int selectedSlot;

    public QuiverTooltipComponent(QuiverTooltip tooltip) {
        this.items = tooltip.stacks();
        this.selectedSlot = tooltip.selected();
    }

    public int method_32661() {
        return this.gridSizeY() * 20 + 2 + 4;
    }

    public int method_32664(class_327 font) {
        return this.gridSizeX() * 18 + 2;
    }

    public void method_32666(class_327 font, int mouseX, int mouseY, class_4587 poseStack, class_918 itemRenderer, int blitOffset) {
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int m = 0; m < i; ++m) {
                int n = mouseX + m * 18 + 1;
                int o = mouseY + l * 20 + 1;
                this.renderSlot(n, o, k++, font, poseStack, itemRenderer, blitOffset);
            }
        }
        this.drawBorder(mouseX, mouseY, i, j, poseStack, blitOffset);
    }

    private void renderSlot(int x, int y, int itemIndex, class_327 font, class_4587 poseStack, class_918 itemRenderer, int blitOffset) {
        if (itemIndex >= this.items.size()) {
            this.blit(poseStack, x, y, blitOffset, Texture.SLOT);
            return;
        }
        class_1799 itemStack = this.items.get(itemIndex);
        this.blit(poseStack, x, y, blitOffset, Texture.SLOT);
        itemRenderer.method_32797(itemStack, x + 1, y + 1, itemIndex);
        itemRenderer.method_4025(font, itemStack, x + 1, y + 1);
        if (itemIndex == this.selectedSlot) {
            class_465.method_33285((class_4587)poseStack, (int)(x + 1), (int)(y + 1), (int)blitOffset);
        }
    }

    private void drawBorder(int x, int y, int slotWidth, int slotHeight, class_4587 poseStack, int blitOffset) {
        int i;
        this.blit(poseStack, x, y, blitOffset, Texture.BORDER_CORNER_TOP);
        this.blit(poseStack, x + slotWidth * 18 + 1, y, blitOffset, Texture.BORDER_CORNER_TOP);
        for (i = 0; i < slotWidth; ++i) {
            this.blit(poseStack, x + 1 + i * 18, y, blitOffset, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(poseStack, x + 1 + i * 18, y + slotHeight * 20, blitOffset, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (i = 0; i < slotHeight; ++i) {
            this.blit(poseStack, x, y + i * 20 + 1, blitOffset, Texture.BORDER_VERTICAL);
            this.blit(poseStack, x + slotWidth * 18 + 1, y + i * 20 + 1, blitOffset, Texture.BORDER_VERTICAL);
        }
        this.blit(poseStack, x, y + slotHeight * 20, blitOffset, Texture.BORDER_CORNER_BOTTOM);
        this.blit(poseStack, x + slotWidth * 18 + 1, y + slotHeight * 20, blitOffset, Texture.BORDER_CORNER_BOTTOM);
    }

    private void blit(class_4587 poseStack, int x, int y, int blitOffset, Texture texture) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE_LOCATION);
        class_332.method_25291((class_4587)poseStack, (int)x, (int)y, (int)blitOffset, (float)texture.x, (float)texture.y, (int)texture.w, (int)texture.h, (int)128, (int)128);
    }

    private int gridSizeX() {
        return this.items.size();
    }

    private int gridSizeY() {
        return 1;
    }

    static enum Texture {
        SLOT(0, 0, 18, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int j, int k, int l, int m) {
            this.x = j;
            this.y = k;
            this.w = l;
            this.h = m;
        }
    }
}

